<?php
/**
 * Copyright © option All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Offdesign\CustomOption\Plugin\Frontend\Magento\Catalog\Model\Product\Option;

class Value
{

    private $logger;

    protected $_productloader;  

    public function __construct(
        \Psr\Log\LoggerInterface $logger,
        \Magento\Catalog\Model\ProductFactory $_productloader
    )
    {
        $this->logger = $logger;
        $this->_productloader = $_productloader;
    }

    public function beforeSetOption(
        \Magento\Catalog\Model\Product\Option\Value $subject,
        $option
    ) {

        $product = $this->getLoadProduct($option->getProductId());
        $option->setProduct($product);
        return [$option];
    }

    public function getLoadProduct($id)
    {
        return $this->_productloader->create()->load($id);
    }
}

