<?php
/**
 * Copyright 2018 aheadWorks. All rights reserved.
 * See LICENSE.txt for license details.
 */


namespace Aheadworks\Faq\Test\Unit\Model\ResourceModel\Article\Grid;

use Aheadworks\Faq\Model\ResourceModel\Article\Grid\Collection;
use Magento\Framework\Api\Search\AggregationInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Select;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Psr\Log\LoggerInterface;

/**
 * Test for Collection
 *
 * @SuppressWarnings(PHPMD.TooManyFields)
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class CollectionTest extends \PHPUnit_Framework_TestCase
{
    /**
     * Main table constant
     */
    const MAIN_TABLE = 'article_table';

    /**
     * @var EntityFactoryInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $entityFactoryMock;

    /**
     * @var LoggerInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $loggerMock;

    /**
     * @var FetchStrategyInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $fetchStrategyMock;

    /**
     * @var ManagerInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $eventManagerMock;

    /**
     * @var AbstractDb|\PHPUnit_Framework_MockObject_MockObject
     */
    private $resourceMock;

    /**
     * @var AdapterInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private $adapterMock;

    /**
     * @var Select|\PHPUnit_Framework_MockObject_MockObject
     */
    private $selectMock;

    /**
     * @var ObjectManager
     */
    private $objectManager;

    /**
     * @var Collection
     */
    private $collectionObject;

    public function setUp()
    {
        $this->objectManager = new ObjectManager($this);

        $this->entityFactoryMock = $this->getMockForAbstractClass(EntityFactoryInterface::class, [], '', false);
        $this->loggerMock = $this->getMockForAbstractClass(LoggerInterface::class, [], '', false);
        $this->fetchStrategyMock = $this->getMockForAbstractClass(FetchStrategyInterface::class, [], '', false);
        $this->eventManagerMock = $this->getMockForAbstractClass(ManagerInterface::class, [], '', false);
        $this->selectMock = $this->getMock(Select::class, [], [], '', false, false);
        $this->adapterMock = $this->getMockForAbstractClass(
            AdapterInterface::class,
            [],
            '',
            false,
            true,
            true,
            ['fetchOne']
        );
        $this->resourceMock = $this->getMockForAbstractClass(
            AbstractDb::class,
            [],
            '',
            false,
            true,
            true,
            ['getMainTable', 'getConnection', 'getTable']
        );

        $this->adapterMock
            ->expects($this->any())
            ->method('select')
            ->willReturn($this->selectMock);

        $this->resourceMock
            ->expects($this->any())
            ->method('getConnection')
            ->willReturn($this->adapterMock);

        $this->resourceMock
            ->expects($this->any())
            ->method('getMainTable')
            ->willReturn(self::MAIN_TABLE);

        $this->resourceMock
            ->expects($this->any())
            ->method('getMainTable')
            ->willReturnArgument(0);

        $this->collectionObject = $this->objectManager->getObject(
            Collection::class,
            [
                'entityFactory' => $this->entityFactoryMock,
                'logger' => $this->loggerMock,
                'fetchStrategy' => $this->fetchStrategyMock,
                'eventManager' => $this->eventManagerMock,
                'resource' => $this->resourceMock,
                'resourceModel' => 'resourceModel',
                'mainTable' => self::MAIN_TABLE
            ]
        );
    }

    /**
     * Set and get aggregations for collection
     *
     * @covers Collection::setAggregations
     * @covers Collection::getAggregations
     */
    public function testGetAndSetAggregations()
    {
        $aggregationMock = $this->getMock(AggregationInterface::class, [], [], '', false);

        $this->collectionObject->setAggregations($aggregationMock);

        $this->assertEquals($aggregationMock, $this->collectionObject->getAggregations());
    }

    /**
     * getSearchCriteria will return always null
     *
     * @covers Collection::getSearchCriteria
     */
    public function testGetSearchCriteria()
    {
        $this->assertNull($this->collectionObject->getSearchCriteria());
    }

    /**
     * setSearchCriteria doesn't do anything
     *
     * @covers Collection::setSearchCriteria
     */
    public function testSetSearchCriteria()
    {
        $searchCriteriaMock = $this->getMock(SearchCriteriaInterface::class, [], [], '', false);

        $this->assertInstanceOf(Collection::class, $this->collectionObject->setSearchCriteria($searchCriteriaMock));
    }

    /**
     * Get total count
     *
     * @covers Collection::getTotalCount
     */
    public function testGetTotalCount()
    {
        $expected = 10;

        $this->adapterMock
            ->expects($this->once())
            ->method('fetchOne')
            ->willReturn($expected);

        $this->assertEquals($expected, $this->collectionObject->getTotalCount());
    }

    /**
     * setSearchCriteria doesn't do anything
     *
     * @covers Collection::setItems
     */
    public function testSetTotalCount()
    {
        $this->assertInstanceOf(Collection::class, $this->collectionObject->setItems([]));
    }
}
