<?php
namespace Custom\ShipQuote\Plugin\Model\Quote\ShippingMethodManagement;

class Method extends \Magento\Quote\Model\ShippingMethodManagement
{

private function getShippingMethods(Quote $quote, $address)
{
    $output = [];
    $shippingAddress = $quote->getShippingAddress();
    $shippingAddress->addData($this->extractAddressData($address));
    $shippingAddress->setCollectShippingRates(true);

    $this->totalsCollector->collectAddressTotals($quote, $shippingAddress);
    $shippingRates = $shippingAddress->getGroupedAllShippingRates();
    foreach ($shippingRates as $carrierRates) {
        foreach ($carrierRates as $rate) {
            $weight = 0;
            foreach($quote->getAllItems() as $item) {
                $weight += ($item->getWeight() * $item->getQty());
            }
            if ($weight > 12 && $rate->getMethod() == "tablerate") {
                // skip this  method
            } else {
                $output[] = $this->converter->modelToDataObject($rate, $quote->getQuoteCurrencyCode());
            }
        }
    }
    return $output;
}

}
