<?php
/**
 * Copyright © 2018 Magenest. All rights reserved.
 * See COPYING.txt for license details.
 *
 * Magenest_QuickBooksDesktop extension
 * NOTICE OF LICENSE
 */

namespace Magenest\QuickBooksDesktop\Controller\Adminhtml\Queue;

use Magenest\QuickBooksDesktop\Model\Config\Source\Queue\Limited;
use Magenest\QuickBooksDesktop\Model\Mapping;
use Magento\Backend\App\Action;
use Magenest\QuickBooksDesktop\Model\QueueFactory;
use Magenest\QuickBooksDesktop\Helper\CreateQueue;
use Magenest\QuickBooksDesktop\Model\Config\Source\Queue\Type;
use Magenest\QuickBooksDesktop\Model\Config\Source\Status;
use Magenest\QuickBooksDesktop\Model\Config\Source\Queue\TypeProduct;

/**
 * Class SyncProduct
 * @package Magenest\QuickBooksDesktop\Controller\Adminhtml\Queue
 */
class SyncProduct extends Action
{
    /**
     * @var QueueFactory
     */
    protected $_queueFactory;

    /**
     * @var CreateQueue
     */
    protected $_queueHelper;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    public $_scopeConfig;

    /**
     * @var Mapping
     */
    public $_map;

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\Collection
     */
    protected $productCollection;

    /**
     * SyncProduct constructor.
     * @param Action\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param QueueFactory $queueFactory
     * @param Mapping $map
     */
    public function __construct(
        Action\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        QueueFactory $queueFactory,
        CreateQueue $createQueue,
        Mapping $map
    )
    {
        parent::__construct($context);
        $this->_queueHelper = $createQueue;
        $this->_scopeConfig = $scopeConfig;
        $this->_queueFactory = $queueFactory;
        $this->_map = $map;
    }

    public function execute()
    {
        try {
            $companyId = $this->_queueHelper->getCompanyId();

            if ($companyId) {
                $mappingCollection = $this->_queueHelper->checkMapping([Type::QUEUE_PRODUCT]);
                $productCollection = $this->getCollection()->setOrder('entity_id', 'ASC');
                if (count($mappingCollection)) {
                    $productCollection->addFieldToFilter('entity_id', ['nin' => $mappingCollection]);
                }
                $productCollection->setPageSize(Limited::LIMITED_PRODUCT);
                $lastPage = $productCollection->getLastPageNumber();

                $totals = 0;
                for ($currentPage = 1; $currentPage <= $lastPage; $currentPage++) {
                    $productCollection->clear();
                    $productCollection->setCurPage($currentPage);
                    foreach ($productCollection as $product) {
                        /** @var \Magento\Catalog\Model\Product $productModel */
                        $productModel = $this->_objectManager->create('\Magento\Catalog\Model\Product');
                        $productId = $product->getId();
                        $productModel = $productModel->load($productId);
//                        $qty = $productModel->getExtensionAttributes()->getStockItem()->getQty();
                        $type = $productModel->getTypeId();
                        $modelCheck = $this->_queueHelper->checkQueue($productId, 'Product');
                        if ($modelCheck->count() == 0) {
                            if ($type == 'virtual' || $type == 'simple' || $type == 'giftcard' || $type == 'downloadable') {
                                $this->_queueHelper->createItemInventoryAddQueue($productId);
                            } else {
                                $this->_queueHelper->createItemNonInventoryAddQueue($productId);
                            }
                        }
                        $totals++;
                    }
                }

                $this->messageManager->addSuccessMessage(
                    __(
                        sprintf('Totals %s Product Queue have been created/updated', $totals)
                    )
                );
            } else {
                $this->messageManager->addErrorMessage('The company is not connected');
            }
        } catch (\Exception $exception) {
            $this->messageManager->addErrorMessage($exception->getMessage());
        }
        $this->_redirect('*/*/index');
    }

    /**
     * @return \Magento\Catalog\Model\ResourceModel\Product\Collection|mixed
     */
    public function getCollection()
    {
        $date = $this->_scopeConfig->getValue('qbdesktop/qbd_setting/date_product');
        if (!$this->productCollection) {
            $this->productCollection = $this->_objectManager
                ->create('\Magento\Catalog\Model\ResourceModel\Product\Collection')
                ->addFieldToFilter('updated_at', ['gteq' => $date]);
        }

        return $this->productCollection;
    }

    /**
     * Always true
     *
     * @return bool
     */
    public function _isAllowed()
    {
        return true;
    }
}
